CREATE OR REPLACE PROCEDURE cambiar_divisas(
	cantidad_euros IN NUMBER,
	cambio_actual IN NUMBER,
	cantidad_comision IN OUT NUMBER,
	cantidad_divisas OUT NUMBER)
AS
	pct_comision CONSTANT NUMBER(3,2) := 0.2;
	minimo_comision CONSTANT NUMBER(6) DEFAULT 3;
BEGIN
	IF cantidad_comision IS NULL THEN
		cantidad_comision := GREATEST(cantidad_euros/100*pct_comision, minimo_comision);
	END IF;
	cantidad_divisas := (cantidad_euros - cantidad_comision) * cambio_actual;
END;
/


CREATE OR REPLACE PROCEDURE mostrar_cambio_divisas(
	eur NUMBER,
	cambio NUMBER)
AS
	v_comision NUMBER(9);
	v_divisas NUMBER(9);
BEGIN
	Cambiar_divisas(eur, cambio, v_comision, v_divisas);
	DBMS_OUTPUT.PUT_LINE('Euros:	 	' || TO_CHAR(Eur, '999,999,999.999'));
	DBMS_OUTPUT.PUT_LINE('Divisas X 1 euro: ' || TO_CHAR(cambio, '999,999,999.999'));
	DBMS_OUTPUT.PUT_LINE('Euros comision: 	' || TO_CHAR(v_comision, '999,999,999.999'));
	DBMS_OUTPUT.PUT_LINE('Cantidad visisas:	' || TO_CHAR(v_divisas, '999,999,999.999'));
END;
/